<?php
// includes/ipinfo_helpers.php

/**
 * Haal ipinfo.io data op voor een gegeven IP, met caching in de sessie.
 *
 * @param string $ip
 * @return array
 */
if (!function_exists('getIpinfoData')) {
    function getIpinfoData($ip) {
        global $config;
        // Caching in sessie: voorkom herhaalde API-calls voor hetzelfde IP
        if (!isset($_SESSION['ipinfo_data'])) {
            $_SESSION['ipinfo_data'] = [];
        }
        if (isset($_SESSION['ipinfo_data'][$ip])) {
            return $_SESSION['ipinfo_data'][$ip];
        }
        $apiKey = isset($config['ipinfo']['api_key']) ? $config['ipinfo']['api_key'] : '';
        $url = "https://ipinfo.io/{$ip}/json?token={$apiKey}";
        $response = @file_get_contents($url);
        $data = [];
        if ($response !== false) {
            $data = json_decode($response, true);
        }
        $_SESSION['ipinfo_data'][$ip] = $data;
        return $data;
    }
}

/**
 * Haal de landcode op voor een gegeven IP.
 *
 * @param string $ip
 * @return string
 */
if (!function_exists('getVisitorCountry')) {
    function getVisitorCountry($ip) {
        $info = getIpinfoData($ip);
        return isset($info['country']) ? $info['country'] : "XX";
    }
}

/**
 * Haal de stad op voor een gegeven IP.
 *
 * @param string $ip
 * @return string
 */
if (!function_exists('getVisitorCity')) {
    function getVisitorCity($ip) {
        $info = getIpinfoData($ip);
        return isset($info['city']) ? $info['city'] : "";
    }
}

/**
 * Haal de regio op voor een gegeven IP.
 *
 * @param string $ip
 * @return string
 */
if (!function_exists('getVisitorRegion')) {
    function getVisitorRegion($ip) {
        $info = getIpinfoData($ip);
        return isset($info['region']) ? $info['region'] : "";
    }
}

/**
 * Haal de tijdzone op voor een gegeven IP.
 *
 * @param string $ip
 * @return string
 */
if (!function_exists('getVisitorTimezone')) {
    function getVisitorTimezone($ip) {
        $info = getIpinfoData($ip);
        return isset($info['timezone']) ? $info['timezone'] : "";
    }
}

/**
 * Haal de organisatie op voor een gegeven IP.
 *
 * @param string $ip
 * @return string
 */
if (!function_exists('getVisitorOrg')) {
    function getVisitorOrg($ip) {
        $info = getIpinfoData($ip);
        return isset($info['org']) ? $info['org'] : "";
    }
}

/**
 * Geef de volledige landnaam op basis van een landcode.
 *
 * @param string $countryCode
 * @return string
 */
if (!function_exists('getCountryName')) {
    function getCountryName($countryCode) {
        $countryCode = strtoupper($countryCode);
        $countries = [
            'AU' => 'Australia',
            'NL' => 'Netherlands',
            'US' => 'United States',
            'GB' => 'United Kingdom',
            'DE' => 'Germany',
            'FR' => 'France',
            'ES' => 'Spain',
            'IT' => 'Italy',
            'PT' => 'Portugal',
            'RU' => 'Russia',
            'CN' => 'China',
            'JP' => 'Japan',
            'IN' => 'India',
            'CA' => 'Canada',
            'BR' => 'Brazil',
            'ZA' => 'South Africa',
            'KR' => 'South Korea'
            // Voeg hier meer landen toe als nodig
        ];
        return isset($countries[$countryCode]) ? $countries[$countryCode] : $countryCode;
    }
}

/**
 * Genereer de vlag-emoji op basis van een landcode.
 *
 * @param string $countryCode
 * @return string
 */
if (!function_exists('getFlagEmoji')) {
    function getFlagEmoji($countryCode) {
        $code = strtoupper($countryCode);
        if (strlen($code) !== 2) {
            return '';
        }
        $offset = 0x1F1E6;
        $firstChar = mb_ord($code[0]) - 65 + $offset;
        $secondChar = mb_ord($code[1]) - 65 + $offset;
        return mb_chr($firstChar) . mb_chr($secondChar);
    }
}

/**
 * Controleer of het IP behoort tot een hostingprovider.
 *
 * @param string $ip
 * @return bool
 */
if (!function_exists('isHostingProvider')) {
    function isHostingProvider($ip) {
        $org = strtolower(getVisitorOrg($ip));
        $hostingKeywords = ['digitalocean','amazon','aws','ovh','leaseweb','linode','vultr','contabo','cloudflare'];
        foreach ($hostingKeywords as $keyword) {
            if (strpos($org, $keyword) !== false) {
                return true;
            }
        }
        return false;
    }
}

/**
 * Controleer of het IP waarschijnlijk een VPN/proxy gebruikt.
 *
 * @param string $ip
 * @return bool
 */
if (!function_exists('isProxyOrVpn')) {
    function isProxyOrVpn($ip) {
        $org = strtolower(getVisitorOrg($ip));
        $vpnKeywords = ['vpn','proxy','tor','guard','tunnel','psiphon','opera'];
        foreach ($vpnKeywords as $kw) {
            if (strpos($org, $kw) !== false) {
                return true;
            }
        }
        return false;
    }
}
?>
