<?php
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Basiscontrole op verdachte User-Agents
$bad_agents = array('curl', 'wget', 'bot', 'crawler', 'spider', 'httpclient');
if (isset($_SERVER['HTTP_USER_AGENT'])) {
    $ua = strtolower($_SERVER['HTTP_USER_AGENT']);
    foreach ($bad_agents as $bad) {
        if (strpos($ua, $bad) !== false) {
            // Directe blokkade: hier kun je eventueel ook naar captcha.php omleiden als gewenst
            header("Location: /captcha.php");
            exit;
        }
    }
}

// Include de advanced detectie module
include_once __DIR__ . '/../includes/detect_advanced.php';
if (detect_advanced_bot()) {
    // In plaats van een directe 'Access Denied'-melding, sturen we de bezoeker naar captcha.php
    header("Location: /captcha.php");
    exit;
}

// JavaScript-verificatie: als de cookie 'js_verified' nog niet staat, stuur de JS-code en reload
if (!isset($_COOKIE['js_verified'])) {
    echo '<html><head><script>
    document.cookie = "js_verified=true; path=/";
    window.location.reload();
    </script></head><body>Please wait...</body></html>';
    exit;
}

// Honeypot-controle: als het verborgen veld is ingevuld, blokkeer dan de aanvraag
if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_POST['hidden_field'])) {
    header("Location: /captcha.php");
    exit;
}

// Initialiseer een teller voor muisbewegingen in de sessie
if (!isset($_SESSION['mouse_moves'])) {
    $_SESSION['mouse_moves'] = 0;
}
?>
