<?php
include_once __DIR__ . '/../includes/ipinfo_helpers.php';
include_once __DIR__ . '/../config/index.php';

$userAgent = $_SERVER['HTTP_USER_AGENT'] ?? '';
$ip = $_SERVER['REMOTE_ADDR'];
if ($ip === '127.0.0.1' || $ip === '::1') {
    $ip = '1.1.1.1';
}

// check user agent: 'googlebot'
if (stripos($userAgent,'googlebot') !== false) {
    // verify via ipinfo if org contains 'Google LLC'
    $info = getIpinfoData($ip);
    $org = strtolower($info['org'] ?? '');
    if (strpos($org,'google') !== false) {
        // OK, legit google
    } else {
        // suspicious => block
        header('HTTP/1.1 403 Forbidden');
        exit("Access denied: suspicious googlebot claim");
    }
}

// check bing
if (stripos($userAgent,'bingbot') !== false) {
    // verify org = 'Microsoft Corporation'
    // ...
}
?>
