<?php
include_once __DIR__ . '/../includes/ipinfo_helpers.php';
include_once __DIR__ . '/../config/index.php';

$ip = $_SERVER['REMOTE_ADDR'];
if ($ip === '127.0.0.1' || $ip === '::1') {
    $ip = '1.1.1.1';
}

// Statische blokkeerlijst
$blocked_patterns = [
    "^66.249.*.*", // google?
    "^64.233.*.*",
    // ...
];

// ipinfo–hosting check
if ($config['block_hosting'] && isHostingProvider($ip)) {
    header('HTTP/1.1 403 Forbidden');
    exit("Access denied: hosting provider");
}

// ipinfo–VPN check
if ($config['block_vpn'] && isProxyOrVpn($ip)) {
    header('HTTP/1.1 403 Forbidden');
    exit("Access denied: VPN/proxy");
}

// Statische regex check
foreach ($blocked_patterns as $pattern) {
    if (preg_match("/".str_replace("*",".*",$pattern)."/",$ip)) {
        header('HTTP/1.1 403 Forbidden');
        exit("Access denied: matched pattern $pattern");
    }
}
// ...
?>
