<?php
if (!function_exists('logbot')) {
    function logbot($message) {
        error_log("[BOT] " . $message . " - IP: " . $_SERVER['REMOTE_ADDR'] . "\n", 3, __DIR__ . "/../logs/clicks.log");
    }
}
if (!function_exists('banbot')) {
    function banbot($redirect = true) {
        $banFile = __DIR__ . "/../ban/banlist.txt";
        $ip = $_SERVER['REMOTE_ADDR'];
        // Lees de huidige banlijst (als de file bestaat)
        $currentBanList = file_exists($banFile) ? file($banFile, FILE_IGNORE_NEW_LINES | FILE_SKIP_EMPTY_LINES) : [];
        if (!in_array($ip, $currentBanList)) {
            file_put_contents($banFile, $ip . "\n", FILE_APPEND);
        }
        setcookie('baneo', '1', time() + 3600, "/");
        if ($redirect) {
            global $config;
            header("Location: " . $config['urls']['botRedirect']);
        }
        exit;
    }
}

$botUA = array(
    "YLT",
    "^b0t$",
    "^COMODO DCV",
    "^Python",
    "^curl",
    "HTTrack",
    "Headless",
    "crawler",
    "node-fetch"
    // Voeg hier extra patronen toe
);

$userAgent = isset($_SERVER['HTTP_USER_AGENT']) ? $_SERVER['HTTP_USER_AGENT'] : "";
foreach ($botUA as $pattern) {
    if (preg_match("/" . $pattern . "/i", $userAgent)) {
        logbot("BANNED USER AGENT: " . $userAgent);
        banbot(false);
    }
}
?>
